/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GameUtils {
    public static Minecraft getMinecraft() {
        return ModUtils.getMinecraft();
    }

    public static Level getWorld() {
        return WorldUtils.getWorld(GameUtils.getMinecraft());
    }

    public static Player getPlayer() {
        return WorldUtils.getPlayer(GameUtils.getMinecraft());
    }

    public static User getSession(Minecraft client) {
        return client != null ? client.getUser() : null;
    }

    public static User getSession() {
        return GameUtils.getSession(GameUtils.getMinecraft());
    }

    public static String getUsername(Minecraft client) {
        return GameUtils.getSession(client).getName();
    }

    public static String getUsername() {
        return GameUtils.getUsername(GameUtils.getMinecraft());
    }

    public static String getUuid(Minecraft client) {
        return GameUtils.getSession(client).getUuid();
    }

    public static String getUuid() {
        return GameUtils.getUuid(GameUtils.getMinecraft());
    }

    public static Screen getCurrentScreen(Minecraft client) {
        return client != null ? client.screen : null;
    }

    public static Screen getCurrentScreen() {
        return GameUtils.getCurrentScreen(GameUtils.getMinecraft());
    }

    public static boolean isFocused(Minecraft client) {
        Screen screen = GameUtils.getCurrentScreen(client);
        return screen != null && (screen.getFocused() != null || WorldUtils.getPlayer(client) != null);
    }

    public static boolean isFocused() {
        return GameUtils.isFocused(GameUtils.getMinecraft());
    }

    public static boolean isLoaded(Minecraft client) {
        return GameUtils.getCurrentScreen(client) != null && !(client.getOverlay() instanceof LoadingOverlay) || WorldUtils.getPlayer(client) != null;
    }

    public static boolean isLoaded() {
        return GameUtils.isLoaded(GameUtils.getMinecraft());
    }
}

