/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ExtendedTextControl
extends EditBox
implements DynamicWidget {
    private static final int DEFAULT_TEXT_LIMIT = 2048;
    private Runnable onKeyEvent;

    public ExtendedTextControl(int componentId, Font fontRendererObj, int x, int y, int widthIn, int heightIn) {
        super(fontRendererObj, x, y, widthIn, heightIn, (Component)new TextComponent(""));
        this.setControlMaxLength(2048);
    }

    public ExtendedTextControl(Font fontRendererObj, int x, int y, int widthIn, int heightIn) {
        this(ExtendedScreen.getNextIndex(), fontRendererObj, x, y, widthIn, heightIn);
    }

    public ExtendedTextControl(Font fontRendererObj, int x, int y, int widthIn, int heightIn, Runnable keyEvent) {
        this(fontRendererObj, x, y, widthIn, heightIn);
        this.setOnKeyTyped(keyEvent);
    }

    @Override
    public int getControlWidth() {
        return this.width;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.height;
    }

    @Override
    public void setControlHeight(int height) {
        this.height = height;
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
    }

    @Override
    public void draw(ExtendedScreen screen) {
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
    }

    @Override
    public int getControlPosX() {
        return this.x;
    }

    @Override
    public void setControlPosX(int posX) {
        this.x = posX;
    }

    @Override
    public int getControlPosY() {
        return this.y;
    }

    @Override
    public void setControlPosY(int posY) {
        this.y = posY;
    }

    public String getControlMessage() {
        return this.getValue();
    }

    public void setControlMessage(String newMessage) {
        this.setValue(StringUtils.getOrDefault(newMessage));
    }

    public boolean isControlEnabled() {
        return this.isEditable();
    }

    public void setControlEnabled(boolean isEnabled) {
        this.setEditable(isEnabled);
    }

    public boolean isControlVisible() {
        return this.isVisible();
    }

    public void setControlVisible(boolean isVisible) {
        this.setVisible(isVisible);
    }

    public int getControlMaxLength() {
        return this.getMaxLength();
    }

    public void setControlMaxLength(int newLength) {
        this.setMaxLength(newLength);
    }

    public boolean isControlFocused() {
        return this.isFocused();
    }

    public void setControlFocused(boolean focused) {
        this.setFocus(focused);
    }

    public void setOnKeyTyped(Runnable event) {
        this.onKeyEvent = event;
    }

    public void onKeyTyped() {
        if (this.onKeyEvent != null) {
            this.onKeyEvent.run();
        }
    }

    public void insertText(@Nonnull String textToWrite) {
        super.insertText(textToWrite);
        this.onKeyTyped();
    }

    public void deleteChars(int num) {
        super.deleteChars(num);
        this.onKeyTyped();
    }
}

