/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Optional;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;

public class ComponentUtils {
    public static DataComponentMap getComponentMap(DataComponentHolder stack) {
        return stack != null ? stack.getComponents() : DataComponentMap.EMPTY;
    }

    public static DataComponentMap getComponentMap(Object data) {
        if (data instanceof DataComponentHolder) {
            DataComponentHolder component = (DataComponentHolder)data;
            return ComponentUtils.getComponentMap(component);
        }
        return DataComponentMap.EMPTY;
    }

    public static TypedDataComponent<?> getComponent(Object data, String path) {
        if (data instanceof DataComponentHolder) {
            DataComponentHolder component = (DataComponentHolder)data;
            return ComponentUtils.getComponent(component, path);
        }
        return null;
    }

    public static TypedDataComponent<?> getComponent(DataComponentHolder stack, String path) {
        return ComponentUtils.getComponent(ComponentUtils.getComponentMap(stack), path);
    }

    public static TypedDataComponent<?> getComponent(DataComponentMap root, String path) {
        if (StringUtils.isNullOrEmpty(path)) {
            return null;
        }
        Optional type = BuiltInRegistries.DATA_COMPONENT_TYPE.getOptional(ResourceUtils.parseResource(path));
        return type.map(arg_0 -> ((DataComponentMap)root).getTyped(arg_0)).orElse(null);
    }

    public static Object parseComponent(TypedDataComponent<?> component) {
        if (component == null) {
            return null;
        }
        return component.value();
    }
}

